/*
 * Copyright 2011 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 */

package android.reader;


import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import android.widget.*; 
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
//import android.view.KeyEvent;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.reader.R;
import android.reader.Application;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.DialogInterface.OnClickListener;

@SuppressLint({ "NewApi", "NewApi", "NewApi" })
public class iso14443a extends Activity {

	EditText mReception;
	private ArrayAdapter<String> adapter;
	private List<String> ModeItems, HaltItems;
    protected Application mApplication;
    protected ReaderAndroid mSerialPort;
    protected int handle;
    protected int address=0x00;
    protected byte mode=0x00, halt=0x00;
    protected byte[] card_flag=new byte[2];
    private SoundPool soundPool;
    private int loadId;
    protected int loopFlag=1;
    private int flag = 0; //数据是否读取成功
    
    @Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.iso14443a);
		
		soundPool = new SoundPool(3, AudioManager.STREAM_MUSIC, 100);       
		loadId = soundPool.load(iso14443a.this, R.raw.card_mp3,1);

 		setTitle("Type-A Reader");
 		((CheckBox)findViewById(R.id.AutoFlag)).setChecked(false);
 		mReception = (EditText) findViewById(R.id.EditTextReception);
 		timer.schedule(task, 300, 300);
 		
 		// Setting Mode of Get Card Serial
 		Spinner mode=(Spinner)findViewById(R.id.mode);
 		mode.setPrompt("Mode");
 		mode.setVisibility(View.VISIBLE);
 		ModeItems = new ArrayList<String>();
 		ModeItems.add(0, "All");
 		ModeItems.add(1, "Idle");
 		adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, ModeItems); 
 		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
 		mode.setAdapter(adapter);
 		
 		Spinner halt=(Spinner)findViewById(R.id.halt);
 		halt.setPrompt("Halt");
 		halt.setVisibility(View.VISIBLE);
 		HaltItems = new ArrayList<String>();
 		HaltItems.add(0, "No Halt");
 		HaltItems.add(1, "Halt");
 		adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, HaltItems); 
 		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
 		halt.setAdapter(adapter);
		
		// 响应按键		
		((Button)findViewById(R.id.btnClear)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnGetCardSN)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnOperateCard)).setOnClickListener(btnOnClick);
		
		mApplication = (Application) getApplication();
		try {
			mSerialPort = mApplication.getSerialPort();
			Log.i("ANDROID","getSerialPort end");
			handle = mSerialPort.getHandle();
			Log.i("ANDROID","mSerialPort.getHandle()");

		} catch (SecurityException e) {
			DisplayError(R.string.error_security);
		} catch (IOException e) {
			DisplayError(R.string.error_unknown);
		} catch (InvalidParameterException e) {
			DisplayError(R.string.error_configuration);
		}
	}
    

    //定时 
    Timer timer = new Timer(); 
 
    Handler handler = new Handler(){
    	public void handleMessage(Message msg) {               	
            	if((loopFlag==1)&&((CheckBox)findViewById(R.id.AutoFlag)).isChecked())
            	{
            		switch(flag){
            		case 0:
            			View v=(View)findViewById(R.id.btnGetCardSN);
            			btnOnClick.onClick(v);
            			break;
            		//case 1:
            		//	((CheckBox)findViewById(R.id.AutoFlag)).setChecked(false);
            		//	flag = 0;
            		//	break;
            		}
            		
            	}
            super.handleMessage(msg);   
        }     
    };
    
    TimerTask task = new TimerTask() {
        public void run() {   
            Message message = new Message();       
            message.what = 1;       
            handler.sendMessage(message);     
        }    
    };
  
    //String To Byte
    public  int  strToByte(String in,int byteSize,byte[] out)
	{
		String str = in.replace(" ", "");
		if(str.length()!=byteSize*2 || out==null)
		{
			return -1;
		}
		str = str.toUpperCase();   	      
	    char[] hexChars = str.toCharArray(); 
	    if(hexChars==null)
	    {
	      return -1;
	    }
	    
	    for (int i = 0; i < byteSize; i++) {   
	        int pos = i * 2;   
	        out[i] = (byte) ((charToByte(hexChars[pos]) << 4 )| (charToByte(hexChars[pos + 1])));   
	    } 
		return 0;	
	}
    
    /**  
     * Convert char to byte  
     * @param c char  
     * @return byte  
     */  
    private int charToByte(char c) {   
        return  "0123456789ABCDEF".indexOf(c);   
    }  
     /*   提示      */
     public void playWav() {
         int BITRATE = 22050;
         int WAVE_HEADER_SIZE = 44;
         int size;
         try {
               File file = new File(android.os.Environment.getExternalStorageDirectory().getAbsolutePath() + "/mp3/card.wav");
               if (file.exists()) {
            	   Log.i("file", "***********************************");
                      size = (int)(file.length());
                      byte [] buff = new byte[size];
                      FileInputStream inputStream = new FileInputStream(file);
                      inputStream.read(buff);
                      if (buff != null) {
                             AudioTrack at = null;
                             int intSize = android.media.AudioTrack.getMinBufferSize(BITRATE,
                                          AudioFormat.CHANNEL_CONFIGURATION_STEREO,
                                          AudioFormat.ENCODING_PCM_16BIT);
                             at = new AudioTrack(AudioManager.STREAM_SYSTEM,
                                          BITRATE,
                                          AudioFormat.CHANNEL_CONFIGURATION_MONO,
                                          AudioFormat.ENCODING_PCM_16BIT,
                                          intSize,
                                          AudioTrack.MODE_STREAM);
                             at.play();
                             at.write(buff, WAVE_HEADER_SIZE, buff.length - WAVE_HEADER_SIZE);
                             at.stop();
                             at.release();
                             at = null;
                             buff = null;
                      }
               }
         } catch (Exception e) {
               e.printStackTrace();
         }
      }   
     
     //ByteToString
     public  String  ByteToStr(int byteSize, byte[] in)
     {
    	 String ret = new String("");    	 
    	 if(in.length < byteSize)
    		 return ret;
    	 
    	 for(int i = 0; i < byteSize; i++)
    	 {
    		 ret = ret.concat(String.format("%1$02X ", in[i]));
    	 }
    	 return ret;
     }
     
     private CbtnOnClick btnOnClick = new CbtnOnClick();
     ////处理按键 
     private class CbtnOnClick implements View.OnClickListener {		
    	
    	@Override   
        public void onClick(View v){
    		loopFlag = 0;
			byte[] ver=new byte[20];
			int	ret;
			
			switch (v.getId()) {
			case R.id.btnGetCardSN:
				Log.i("ANDROID","btnGetCardSn");
				mode = (byte)((((Spinner)findViewById(R.id.mode)).getLastVisiblePosition())&0xff);
				halt = (byte)((((Spinner)findViewById(R.id.halt)).getLastVisiblePosition())&0xff);
				ret = mSerialPort.getCardSN(handle, address, mode, halt, card_flag, ver);
				if(0 == ret)
				{
					mReception.append("read Card SN:"+ ByteToStr(card_flag[1], ver) + "\n");				
			        soundPool.play(loadId , 15, 15, 1, 0, 1);
				}
				else if(ret==4)
				{
					mReception.append("\ndevice connect faild");
					//flag = 1;			
				}
				else
				{
					//flag = 1;
				}
				break;
			case R.id.btnOperateCard:
				Log.i("ANDROID","btnOperateCard");
				startActivity(new Intent(iso14443a.this, CardOperate.class));
				break;
			case R.id.btnClear:
				mReception.setText("");
				break;
			}		
			loopFlag=1;	
		}
	}    
    
    private void DisplayError(int resourceId) {
		AlertDialog.Builder b = new AlertDialog.Builder(iso14443a.this);
		b.setTitle("Error");
		b.setMessage(resourceId);
		b.setPositiveButton("OK", new OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				iso14443a.this.finish();
			}
		});
		b.show();
	}
    
	@Override
	protected void onDestroy() {		
		mApplication.closeSerialPort();
		mSerialPort = null;
		timer.cancel();
		super.onDestroy();
	}	
}